import { SidebarGroup, SidebarGroupLabel, SidebarGroupContent, SidebarMenu } from "../ui/sidebar";
import { PageCollection } from "@/types/app";
import { NavigationPage } from "./navigation.page";

export function NavigationPageCollection({ items, icon, enabled, title }: PageCollection) {
    if (!enabled) {
        return null;
    }

    return (
        <SidebarGroup>
            <SidebarGroupLabel className="group/label">
                <div>
                    {icon}
                    <span>{title}{" "}</span>
                </div>
            </SidebarGroupLabel>
            <SidebarGroupContent className="pl-2">
                <SidebarMenu>
                {items.map((item) => (
                    <NavigationPage 
                        key={item.url}
                        {...item}
                    />
                ))}
                </SidebarMenu>
            </SidebarGroupContent>
        </SidebarGroup>
    )
}